/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.entity.condition;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stevekung.fishofthieves.entity.condition.SpawnCondition;
import com.stevekung.fishofthieves.entity.condition.SpawnConditionContext;
import com.stevekung.fishofthieves.entity.condition.SpawnConditionType;
import com.stevekung.fishofthieves.registry.FOTSpawnConditions;
import com.stevekung.fishofthieves.utils.TerrainUtils;
import java.util.Optional;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;

public record MatchMinimumBlocksInRangeCondition(Optional<HolderSet<Block>> blocks, Optional<HolderSet<Fluid>> fluids, int range, int size) implements SpawnCondition
{
    public static final MapCodec<MatchMinimumBlocksInRangeCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)RegistryCodecs.homogeneousList((ResourceKey)Registries.BLOCK).optionalFieldOf("blocks").forGetter(MatchMinimumBlocksInRangeCondition::blocks), (App)RegistryCodecs.homogeneousList((ResourceKey)Registries.FLUID).optionalFieldOf("fluids").forGetter(MatchMinimumBlocksInRangeCondition::fluids), (App)Codec.intRange((int)1, (int)32).fieldOf("range").forGetter(MatchMinimumBlocksInRangeCondition::range), (App)Codec.intRange((int)1, (int)64).fieldOf("size").forGetter(MatchMinimumBlocksInRangeCondition::size)).apply((Applicative)instance, MatchMinimumBlocksInRangeCondition::new));

    @Override
    public SpawnConditionType getType() {
        return FOTSpawnConditions.MATCH_MINIMUM_BLOCKS_IN_RANGE;
    }

    @Override
    public boolean test(SpawnConditionContext context) {
        ServerLevel level = context.level();
        if (this.blocks.isPresent() && TerrainUtils.lookForBlocksWithSize(context.blockPos(), this.range, this.size, blockPos2 -> level.getBlockState(blockPos2).is(this.blocks.get()))) {
            return true;
        }
        return this.fluids.isPresent() && TerrainUtils.lookForBlocksWithSize(context.blockPos(), this.range, this.size, blockPos2 -> level.getFluidState(blockPos2).is(this.fluids.get()) && level.getFluidState(blockPos2).isSource());
    }

    public static SpawnCondition.Builder minimumBlocksInRange(Optional<HolderSet<Block>> blocks, Optional<HolderSet<Fluid>> fluids, int range, int size) {
        return () -> new MatchMinimumBlocksInRangeCondition(blocks, fluids, range, size);
    }
}

